#ifndef _DEVCONFIG_H_
#define _DEVCONFIG_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "dllexport.h"

#define DAYS_IN_ONE_WEEK 7   //һںеĿ
#define HOURS_IN_ONE_DAY 24  //һ캬еСʱĿ
typedef enum
{
	E_DEFAULT_VALUE,  //0 Ĭֵ
	E_VALID_MOTION,   //1 ƶ
	E_VALID_LOSS,     //2 LOSSӦЧֵ
    E_VALID_SENSOR = 4, //SensorӦЧֵ
};

typedef enum
{
    E_UPGRADE_SUCCEDD,       //ɹ
    E_UPGRADE_FAILED,        //ʧ
    E_UPGRADE_INVALID_FILE,  //ļǷ
    E_UPGRADE_TIMEOUT,       //ʱ
	E_UPGRADE_BUSY,          //ϵͳæ
};

typedef enum
{
	E_EXPORT_SUCCEDD,       //ļɹ
	E_EXPORT_FAILED,        //ļʧ
	E_EXPORT_INVALID_FILE,  //ļǷ
	E_EXPORT_TIMEOUT,       //ʱ
	E_EXPORT_BUSY,          //ϵͳæ
};

typedef enum
{
	E_IMPORT_SUCCEDD,       //ļɹ
	E_IMPORT_FAILED,        //ļʧ
	E_IMPORT_INVALID_FILE,  //ļǷ
	E_IMPORT_TIMEOUT,       //ʱ
	E_IMPORT_BUSY,          //ϵͳæ
};


class IDevUserLogin;
class IDevPreview;
typedef IDevPreview* (*GetPreviewCallback)(const int iChnIdex);


typedef enum
{
    DEV_INFO_CFG,
    DEV_NET_CFG,
    DEV_NET_CFG2,
    DEV_EMAIL_PARA_CFG,
    DEV_TIME_CFG,
    DEV_PTZ_CFG,
    DEV_RS232_CFG,
    DEV_RS232_PPP2_CFG,
    DEV_RS232_CFG2,
    DEV_COMPRESS_CFG,
    DEV_COMPRESS_CFG2,
    DEV_PTZ_DECODER_CFG,
    DEV_PTZ_DECODER_CFG2,
    DEV_RECORD_CFG,
    DEV_RECORD_CFG2,
    DEV_PIC_CFG,
    DEV_PIC_CFG2,
    DEV_ALARM_IN_CFG,
    DEV_ALARM_IN_CFG2,
    DEV_ALARM_OUT_CFG,
    DEV_ALARM_OUT_CFG2,
    DEV_PREVIEW_CFG,
    DEV_PREVIEW_CFG2,
    DEV_VIDEOOUT_CFG,
    DEV_VIDEOOUT_CFG2,
    DEV_VIDEO_OSD_CFG,
    DEV_NTP_CFG,
    DEV_DDNS_CFG,
    DEV_DDNS_CFG2,
    DEV_EMAIL_CFG,
    DEV_EMAIL_CFG2,
    DEV_FTP_CFG,
    DEV_SIP_CFG,
    DEV_WLAN_CFG,
    DEV_WATERMAKE_CFG,
    DEV_DISK_CFG,
    DEV_INFRARED_CFG,
    DEV_IPFILTER_CFG,
    DEV_MMS_CFG,
    DEV_IP_ALARMIN_CFG,
    DEV_IP_ALARM_OUT_CFG,
    DEV_USER_CFG,
    DEV_USER2_CFG,
    DEV_SHOWSTRING_CFG,
    DEV_SHOWSTRING_CFG2,
    DEV_EXCEPTION_CFG,
    DEV_EXCEPTION_CFG2,
    DEV_ZONEANDDST_CFG,
    DEV_PREVIEW_AUX_CFG,
    DEV_PREVIEW_AUX_CFG2,
    DEV_AUXOUT_CFG,
    DEV_NETAPP_CFG,
    DEV_NFS_CFG,
    DEV_IPPARA_CFG,
    DEV_IPPARA_CFG2,
	DEV_COMPRESSION_AUD_CFG,
	DEV_RTSP_CFG,
	DEV_SERIAL_START,
	DEV_SERIAL_SEND,
	DEV_SENDTO_SERIALPORT,
	DEV_SENDTO_232PORT,
	DEV_SERIAL_END,
	DEV_HD_CFG,
	DEV_SCALE_CFG,
	DEV_NET_LOCAL,
	DEV_NET_3G,
	DEV_NET_HTTP,
	DEV_NET_SERVICE,
	DEV_NET_FTP_CFG,
	DEV_NET_FTP_TASK,
	DEV_NET_IPFILTER,
    DEV_NET_PPPOECFG,
    DEV_NET_LINKTYPE,
    DEV_NET_UPNP_STATE,
    DEV_NET_OUTPUT_CFG,

	DEV_NET_VERSION,
	INFO_GET_RECORDSCHEDULE,
	DEV_HDDFULL_EXCEPTION,
	DEV_HDDERR_EXCEPTION,
	DEV_NETDISCONNECT_EXCEPTION,
	DEV_IPCONFLICT_EXCEPTION,
	DEV_SHUTDOWN,
	DEV_REBOOT,

	DEV_EXPORT_CFG,
	DEV_IMPORT_CFG,
    DEV_RESTORE,
    DEV_AUTO_REBOOT_CFG,
    DEV_GET_HDD_CFG,
    DEV_INIT_HDD,
    DEV_SYSGENERAL_CFG,
    DEV_DST_CFG,
} DeviceCfgIndex;

#define MAX_RESO_TYPES 10

#define MAX_QUAULITY_TYPES MAX_RESO_TYPES
#define MAX_QUAULITY_NUM 10

#define MAX_FRAME_TYPES MAX_RESO_TYPES
#define MAX_FRAME_NUM 20

#define MAX_BIT_RATE_TYPES MAX_RESO_TYPES
#define MAX_BIT_RATE_NUM 15

typedef struct tagResoInfo
{
	/*
	int					reso;
	int					index;
	int					def;
	char				szReso[32];
	*/
	int		channel[4];		//channel bit, use bit OR
	int		streamType;		//main stream:0  substream:1
	int		reso;
	char	strReso[32];
} ResoInfo;

typedef struct tagQuaulityInfo
{
	/*int quaulityTypes;
	int quaulity[MAX_QUAULITY];*/
	int		quaulityTypes;
	int		quaulity[MAX_QUAULITY_NUM];
} QuaulityInfo;

typedef struct tagFrameInfo
{
	/*int min;
	int max;
	int def;
	int types;
	int frame[MAX_FRAME];*/
	int		min;					//min frame rate
	int		max;					//max frame rate
	int		def;
	int		types;					//frame types to choose
	int		frame[MAX_FRAME_NUM];	//frame list 
} FrameInfo;

typedef struct tagBitrateInfo
{
	/*int				min;
	int				max;
	int				def;
	int				types;
	int				times;
	int				bitrate[MAX_BITRATE];*/
	int		min;							//min bit rate
	int		max;							//max bit rate
	int		def;
	int		types;							// bit rate types to choose
	int		times;							//relationship between bit rat and frame rate
	int		bitRate[MAX_BIT_RATE_NUM];		//bit rate list
} BitrateInfo;

typedef struct tagCOMPRESSION_INFO
{
	/*
	ResoInfo		reso;
	QuaulityInfo	quaulity;
	FrameInfo		frame;
	BitrateInfo		bitRate;
	*/
	int				nResoCount;
	ResoInfo		reso[MAX_RESO_TYPES];//resolution list

	QuaulityInfo	quaulity[MAX_QUAULITY_TYPES];

	FrameInfo		frame[MAX_FRAME_TYPES];

	BitrateInfo		bitRate[MAX_BIT_RATE_TYPES];
} COMPRESSION_INFO, *LPCOMPRESSION_INFO;

typedef struct tagDEV_INFO
{
    DWORD    dwsize;
    BYTE     sDVRName[32];
    DWORD    dwDVRID;  
    BYTE     byAlarmInPortNum;
    BYTE     byAlarmOutPortNum;
    BYTE     byRS232Num;
    BYTE     byRS485Num;
    BYTE     byNetworkPortNum;
    BYTE     byDiskCtrlNum;
    BYTE     byDiskNum;
    BYTE     byDVRType;
    BYTE     byChanNum;
    BYTE     byStartChan;
    BYTE     byDecordChans;
    BYTE     byVGANum;
    BYTE     byUSBNum;
    BYTE     byAuxoutNum;
    BYTE     byAudioNum;
    BYTE     byIPChanNum;
	DWORD    norm;
	DWORD    fmt;
	DWORD    language;
} DEV_INFO;

// 汾Ϣ
typedef struct tagDEV_VERSION
{
	char	cName[32];
	char	cType[32];
	char	cSerialNo[32];
	char	cBuildDay[32];
	char	cHardwareVer[32];
	char	cCfgVer[32];
	char	cFirmwareVer[32];
	char	cDetail[128];
	char    res[16];
} DEV_VERSION;

typedef struct tagDEV_TIME
{
    DWORD    dwYear;
    DWORD    dwMonth;
    DWORD    dwDay;
    DWORD    dwHour;
    DWORD    dwMinute;
    DWORD    dwSecond;
} DEV_TIME;

typedef struct tagDEV_EMAIL
{
    char     sUserName[32];
    char     sPassWord[32];
    char     sToName[32];
    char     sToAddr[48];
    char     sEmailServer[32];
    BYTE     byServerType;
    BYTE     byUseAuthen;
    BYTE     byAttachment;
    BYTE     byMailinterval;
} DEV_EMAIL;

typedef struct tagDEV_EMAILERINFO
{
    BYTE  sName[32];
    BYTE  sAddress[48]; 
} DEV_EMAILERINFO;

typedef struct tagDEV_EMAIL2
{
    DWORD                    dwSize;
    BYTE                     sAccount[32];
    BYTE                     sPassword[32];
    DEV_EMAILERINFO          struSender;
    BYTE                     sSmtpServer[48];
    BYTE                     sPop3Server[48];
    DEV_EMAILERINFO          struReceiver[3];
    BYTE                     byAttachment;
    BYTE                     bySmtpServerVerify;
    BYTE                     byMailInterval;
    BYTE                     byEnableSSL;
    WORD                     wSmtpPort;
    BYTE                     byRes[74];  
} DEV_EMAIL2;

typedef struct tagNetDvrExceptionCfg2
{
	int triggerBuzzer;
	int triggerSnap;
	int triggerOut[32];
	int iShowException;
	int reserve;
}NetDvrExceptionCfg2, *PNetDvrExceptionCfg2;

typedef struct tagDEV_IPADDR
{
    char    sIpV4[16];
    BYTE    sIpV6[128];
} DEV_IPADDR;

typedef struct tagDEV_ETHERNET
{
    char    sDVRIP[16];
    char    sDVRIPMask[16];
    DWORD   dwNetInterface;
    WORD    wDVRPort;
    BYTE    byMACAddr[6];
} DEV_ETHERNET;

typedef struct tagDEV_NET
{
    DEV_ETHERNET         struEtherNet[2];
    char                 sManageHostIP[16];
    WORD                 wManageHostPort;
    char                 sIPServerIP[16];
    char                 sMultiCastIP[16];
    char                 sGatewayIP[16];
    char                 sNFSIP[16];
    BYTE                 sNFSDirectory[128];
    DWORD                dwPPPOE;
    BYTE                 sPPPoEUser[32];
    char                 sPPPoEPassword[16];
    char                 sPPPoEIP[16];
    WORD                 wHttpPort;
} DEV_NET;

typedef struct tagDEV_ETHERNET2
{
    DEV_IPADDR        struDVRIP;
    DEV_IPADDR        struDVRIPMask;
    DWORD             dwNetInterface;
    WORD              wDVRPort;
    WORD              wMTU;
    BYTE              byMACAddr[6]; 
} DEV_ETHERNET2;

typedef struct tagDEV_PPPOE
{
    DWORD             dwPPPOE;
    BYTE              sPPPoEUser[32];
    char              sPPPoEPassword[16];
    DEV_IPADDR        struPPPoEIP;
} DEV_PPPOE;

typedef struct tagDEV_NET2
{
    DWORD                    dwSize;
    DEV_ETHERNET2            struEtherNet[2];
    DEV_IPADDR               struRes1[2];
    DEV_IPADDR               struAlarmHostIpAddr;
    WORD                     wRes2[2];
    WORD                     wAlarmHostIpPort;
    BYTE                     byUseDhcp;
    BYTE                     byRes3;
    DEV_IPADDR               struDnsServer1IpAddr;
    DEV_IPADDR               struDnsServer2IpAddr;
    BYTE                     byIpResolver[64];
    WORD                     wIpResolverPort;
    WORD                     wHttpPortNo;
    DEV_IPADDR               struMulticastIpAddr;
    DEV_IPADDR               struGatewayIpAddr;
    DEV_PPPOE                struPPPoE;
    BYTE                     byRes[64];
} DEV_NET2;

typedef struct tagDEV_COMPRESSION_INFO
{
    BYTE     byStreamType;
    BYTE     byResolution;
    BYTE     byBitrateType;
    BYTE     byPicQuality;
    DWORD    dwVideoBitrate;
    DWORD    dwVideoFrameRate;
} DEV_COMPRESSION_INFO;

typedef struct tagDEV_COMPRESSION_INFO2
{
    BYTE     byStreamType;
    BYTE     byResolution;
    BYTE     byBitrateType;
    BYTE     byPicQuality;
    DWORD    dwVideoBitrate;
    DWORD    dwVideoFrameRate;
    WORD     wIntervalFrameI;
    BYTE     byIntervalBPFrame;
    BYTE     byVideoEncType;
    BYTE     byAudioEncType;
} DEV_COMPRESSION_INFO2;

typedef struct tagDEV_COMPRESS
{
    DWORD                       dwSize;
    DEV_COMPRESSION_INFO        struNormHighRecordPara;
    DEV_COMPRESSION_INFO        struEventRecordPara;
    DEV_COMPRESSION_INFO        struNetPara; 
} DEV_COMPRESS;

/*typedef struct
{
    DWORD                       dwSize;
    DEV_COMPRESSION_INFO2       struNormHighRecordPara;
    DEV_COMPRESSION_INFO2       struEventRecordPara;
    DEV_COMPRESSION_INFO2       struNetPara; 
}DEV_COMPRESS2;*/

typedef struct tagCompression_Channel
{
	int		bAudio;
	int		nResolution;
	int		nEnctype;
	int		nPicQuaulity;
	int		nFrame;
	int		nCustom;
	int		nBitrate;
} Compression_Channel;

typedef struct tagDEV_COMPRESS2
{
	int						bHD;			//is hd channel or not
	int						streamTypes;	//valid stream types
	Compression_Channel		ccMainStream;
	Compression_Channel		ccSubStream;
	Compression_Channel		ccResStream;	
} DEV_COMPRESS2;

typedef struct tagDEV_SCHEDTIME
{
    BYTE    byStartHour;
    BYTE    byStartMin;
    BYTE    byStopHour;
    BYTE    byStopMin;
} DEV_SCHEDTIME;

typedef struct tagDEV_HANDLEEXCEPTION
{
    DWORD    dwHandleType;
    BYTE     byRelAlarmOut[4];
} DEV_HANDLEEXCEPTION;

typedef struct tagDEV_HANDLEEXCEPTION2
{
    DWORD    dwHandleType;
    BYTE     byRelAlarmOut[96];
} DEV_HANDLEEXCEPTION2;

typedef struct tagDEV_VILOST
{
    BYTE                   byEnableHandleVILost;
    DEV_HANDLEEXCEPTION    strVILostHandleType;
    DEV_SCHEDTIME          struAlarmTime[7][8];
} DEV_VILOST;

typedef struct tagDEV_MOTION
{
    BYTE                           byMotionScope[64][96];
    BYTE                           byMotionSensitive;
    BYTE                           byEnableHandleMotion;
    BYTE                           byPrecision;
    DEV_HANDLEEXCEPTION            strMotionHandleType;
    DEV_SCHEDTIME                  struAlarmTime[7][4];
    BYTE                           byRelRecordChan[64];
} DEV_MOTION;

typedef struct tagDEV_COLOR
{
    BYTE    byBrightness;
    BYTE    byContrast;
    BYTE    bySaturation;
    BYTE    byHue;
} DEV_COLOR;

typedef struct tagDEV_VILOST2
{
    BYTE                           byEnableHandleVILost;
    DEV_HANDLEEXCEPTION2           strVILostHandleType;
    //DEV_SCHEDTIME                  struAlarmTime[7][8];
	int							   ivalid;
	int			                   struAlarmTime[DAYS_IN_ONE_WEEK][HOURS_IN_ONE_DAY];
} DEV_VILOST2;

typedef struct tagSENSITIVITY_INFO
{
    BYTE byBeginHour;
    BYTE byBeginMinute;
    BYTE byEndHour;
    BYTE byEndMinute;
    BYTE bySensitivity;
    BYTE byRes[3];
}SENSITIVITY_INFO;

typedef struct tagDEV_MOTION2
{
	int                            iWidth;
	int                            iHight;
    BYTE                           byMotionScope[64][96];
    SENSITIVITY_INFO               szSensitivityInfo[4];
    BYTE                           byEnableHandleMotion;
    BYTE                           szRes[3];
    DEV_HANDLEEXCEPTION2           strMotionHandleType;
    //DEV_SCHEDTIME                  struAlarmTime[7][8];
	int							   invalid;
	int							   struAlarmTime[DAYS_IN_ONE_WEEK][HOURS_IN_ONE_DAY];
    BYTE                           byRelRecordChan[64];
} DEV_MOTION2;

typedef struct tagDEV_HIDEALARM
{
    DWORD                          dwEnableHideAlarm;
    WORD                           wHideAlarmAreaTopLeftX;
    WORD                           wHideAlarmAreaTopLeftY;
    WORD                           wHideAlarmAreaWidth;
    WORD                           wHideAlarmAreaHeight;
    DEV_HANDLEEXCEPTION            strHideAlarmHandleType;
    DEV_SCHEDTIME                  struAlarmTime[7][4];
} DEV_HIDEALARM;

typedef struct tagDEV_HIDEALARM2
{
    DWORD                          dwEnableHideAlarm;
    WORD                           wHideAlarmAreaTopLeftX;
    WORD                           wHideAlarmAreaTopLeftY;
    WORD                           wHideAlarmAreaWidth;
    WORD                           wHideAlarmAreaHeight;
    DEV_HANDLEEXCEPTION2           strHideAlarmHandleType;
    //DEV_SCHEDTIME                  struAlarmTime[7][8];
	int                            invalid;
	int                            struAlarmTime[7][24];
} DEV_HIDEALARM2;

typedef struct tagDEV_SHELTER
{
    INT    wHideAreaTopLeftX;
    INT    wHideAreaTopLeftY;
    INT    wHideAreaWidth;
    INT    wHideAreaHeight;
} DEV_SHELTER;

typedef struct tagDEV_PTZ_PROTOCOL
{ 
    DWORD dwType;               /*ֵ*/    
    BYTE  byDescribe[16]; /*8000еһ*/    
}DEV_PTZ_PROTOCOL;

typedef struct tagDEV_PTZ
{
    DWORD   dwSize;    
    DEV_PTZ_PROTOCOL struPtz[200];/*200PTZЭ*/    
    DWORD   dwPtzNum;           /*ЧptzЭĿ0ʼ(ʱ1)*/
    BYTE    byRes[8]; 
}DEV_PTZ;

typedef struct tagDEV_ALARM_IN
{
    DWORD                         dwSize;
    BYTE                          sAlarmInName[32];
    BYTE                          byAlarmType;
    BYTE                          byAlarmInHandle;
    DEV_HANDLEEXCEPTION           struAlarmHandleType;
    DEV_SCHEDTIME                 struAlarmTime[7][4];
    BYTE                          byRelRecordChan[16];
    BYTE                          byEnablePreset[16];
    BYTE                          byPresetNo[16];
    BYTE                          byEnableCruise[16];
    BYTE                          byCruiseNo[16];
    BYTE                          byEnablePtzTrack[16];
    BYTE                          byPTZTrack[16];
} DEV_ALARM_IN;

typedef struct tagDEV_ALARM_IN2
{
    DWORD                            dwSize;
    BYTE                             sAlarmInName[32];
    BYTE                             byAlarmType;
    BYTE                             byAlarmInHandle;
    BYTE                             byRes1[2];
    DEV_HANDLEEXCEPTION2             struAlarmHandleType;
    //DEV_SCHEDTIME                    struAlarmTime[7][8];
	int                              invalid;
	int                              byTimeTable[7][24];
    BYTE                             byRelRecordChan[64];
    BYTE                             byEnablePreset[64];
    BYTE                             byPresetNo[64];
    BYTE                             byRes2[192];
    BYTE                             byEnableCruise[64];
    BYTE                             byCruiseNo[64];
    BYTE                             byEnablePtzTrack[64];
    BYTE                             byPTZTrack[64];
    BYTE                             byRes3[16];
} DEV_ALARM_IN2;

typedef struct tagDEV_ALARM_OUT
{
    BYTE                    sAlarmOutName[32];
    DWORD                   dwAlarmOutDelay;
    DEV_SCHEDTIME           struAlarmOutTime[7][4];
} DEV_ALARM_OUT;

typedef struct tagDEV_ALARM_OUT2
{
    DWORD                   dwSize;
    BYTE                    sAlarmOutName[32];
    DWORD                   dwAlarmOutDelay;
    //DEV_SCHEDTIME           struAlarmOutTime[7][8];
	int                     invalid;
	int                     struAlarmOutTime[7][24];
    BYTE                    byRes[16];
} DEV_ALARM_OUT2;

typedef struct tagDEV_IP_ALARM_OUT
{
    BYTE     byIPID;
} DEV_IP_ALARM_OUT;



typedef struct tagDEV_PIC
{
    DWORD                    dwSize;
    BYTE                     sChanName[32];
    DWORD                    dwVideoFormat;
    DEV_COLOR                struColor;
    char                     reservedData[60];
    DWORD                    dwShowChanName;
    DWORD                    dwShowNameTopLeftX;
    DWORD                    dwShowNameTopLeftY;
    DEV_VILOST               struVILost;
    DEV_VILOST               struRes;
    DEV_MOTION               struMotion;
    DEV_HIDEALARM            struHideAlarm;
    DWORD                    dwEnableHide;
    DEV_SHELTER              struShelter[4];
    DWORD                    dwShowOsd;
    DWORD                    dwOSDTopLeftX;
    DWORD                    dwOSDTopLeftY;
    BYTE                     byOSDType;
    BYTE                     byDispWeek;
    BYTE                     byOSDAttrib;
    BYTE                     byHourOsdType;
    BYTE                     byRes[64];
} DEV_PIC;

typedef struct tagDEV_PIC2
{
    DWORD                    dwSize;
    BYTE                     sChanName[32];
    DWORD                    dwVideoFormat;
    DEV_COLOR                struColor;
    char                     reservedData[60];
    DWORD                    dwShowChanName;
    DWORD                    dwShowNameTopLeftX;
    DWORD                    dwShowNameTopLeftY;
    DEV_VILOST2              struVILost;
    DEV_VILOST2              struRes;
    DEV_MOTION2              struMotion;
    DEV_HIDEALARM2           struHideAlarm;
    DWORD                    dwEnableHide;
    DEV_SHELTER              struShelter[4];
    DWORD                    dwShowOsd;
    DWORD                    dwOSDTopLeftX;
    DWORD                    dwOSDTopLeftY;
    BYTE                     byOSDType;
    BYTE                     byDispWeek;
    BYTE                     byOSDAttrib;
    BYTE                     byHourOsdType;
    BYTE                     byRes[64];
} DEV_PIC2;

typedef struct tagDEV_PPP
{
    char      sRemoteIP[16];
    char      sLocalIP[16];
    char      sLocalIPMask[16];
    BYTE      sUsername[32];
    BYTE      sPassword[16];
    BYTE      byPPPMode;
    BYTE      byRedial;
    BYTE      byRedialMode;
    BYTE      byDataEncrypt;
    DWORD     dwMTU;
    char      sTelephoneNumber[32];
} DEV_PPP;

typedef struct tagDEV_PPP2
{
    DEV_IPADDR          struRemoteIP;
    DEV_IPADDR          struLocalIP;
    char                sLocalIPMask[16];
    BYTE                sUsername[32];
    BYTE                sPassword[16];
    BYTE                byPPPMode;
    BYTE                byRedial;
    BYTE                byRedialMode;
    BYTE                byDataEncrypt;
    DWORD               dwMTU;
    char                sTelephoneNumber[32];
} DEV_PPP2;

typedef struct tagDEV_RS232
{ 
    DWORD       dwBaudRate;
    BYTE        byDataBit;
    BYTE        byStopBit;
    BYTE        byParity;
    BYTE        byFlowcontrol;
    DWORD       dwWorkMode;
} DEV_RS232;

typedef struct tagDEV_RS232_PPP
{
    DWORD               dwSize;
    DWORD               dwBaudRate;
    BYTE                byDataBit;
    BYTE                byStopBit;
    BYTE                byParity;
    BYTE                byFlowcontrol;
    DWORD               dwWorkMode;
    DEV_PPP             struPPPConfig;
} DEV_RS232_PPP;

typedef struct tagDEV_RS232_PPP2
{
    DWORD                     dwSize;
    DEV_RS232                 struRs232;
    BYTE                      byRes[84];
    DEV_PPP2                  struPPPConfig;
} DEV_RS232_PPP2;

typedef struct tagDEV_PTZ_DECODER
{
    DWORD     dwSize;
    DWORD     dwBaudRate;
    BYTE      byDataBit;
    BYTE      byStopBit;
    BYTE      byParity;
    BYTE      byFlowcontrol;
    WORD      wDecoderType;
    WORD      wDecoderAddress;
    BYTE      bySetPreset[256];
    BYTE      bySetCruise[256];
    BYTE      bySetTrack[256];
} DEV_PTZ_DECODER;

typedef struct tagDEV_PTZ_DECODER2
{
    DWORD     dwSize;
    DWORD     dwBaudRate;
    BYTE      byDataBit;
    BYTE      byStopBit;
    BYTE      byParity;
    BYTE      byFlowcontrol;
    WORD      wDecoderType;
    WORD      wDecoderAddress;
    BYTE      bySetPreset[256];
    BYTE      bySetCruise[256];
    BYTE      bySetTrack[256];
} DEV_PTZ_DECODER2;

typedef struct tagDEV_RECORD_DAY
{
    WORD    wAllDayRecord;
    BYTE    byRecordType;
    char    reservedData;
} DEV_RECORD_DAY;

typedef struct tagDEV_RECORD_SCHED
{
    DEV_SCHEDTIME        struRecordTime; 
    unsigned int         byRecordType;
    //char                 reservedData[3];
} DEV_RECORD_SCHED;

typedef struct tagDEV_RECORD
{
    DWORD                 dwSize;
    DWORD                 dwRecord;
    DEV_RECORD_DAY        struRecAllDay[7]; 
    DEV_RECORD_SCHED      struRecordSched[7][4];
    DWORD                 dwRecordTime;
    DWORD                 dwPreRecordTime;
} DEV_RECORD;

// ¼ƻ
typedef struct tagINFO_RECORDSCHEDULE
{
	DWORD					dwRecord;
	DEV_RECORD_DAY			struRecAllDay[7];
	int						invalidType;
    DEV_RECORD_SCHED		struRecordSched[7][24];
} INFO_RECORDSCHEDULE;

/*
typedef struct tagDEV_RECORD2
{
    DWORD                 dwSize;
    DWORD                 dwRecord;
    DEV_RECORD_DAY        struRecAllDay[7];
    DEV_RECORD_SCHED      struRecordSched[7][8];
    DWORD                 dwRecordTime;
    DWORD                 dwPreRecordTime;
    DWORD                 dwRecorderDuration;
    BYTE                  byRedundancyRec;
    BYTE                  byAudioRec;
    BYTE                  byReserve[10];
} DEV_RECORD2;
*/

typedef struct tagDEV_RECORD2
{
	DWORD				dwSize;
	DWORD               bCycle;
	DWORD               packageTime;
	DWORD               dwRecordTime;
	DWORD               dwPreRecordTime;
	DWORD               dwRecorderDuration;
	BYTE                byRedundancyRec;
	BYTE				byAudioRec;
	BYTE				byReserve[10];
} DEV_RECORD2;

typedef struct tagDEV_SHOWSTRINGINFO
{
    WORD       wShowString;
    WORD       wStringSize;
    WORD       wShowStringTopLeftX;
    WORD       wShowStringTopLeftY;
    char       sString[44];  
} DEV_SHOWSTRINGINFO;

typedef struct tagDEV_SHOWSTRING
{
    DEV_SHOWSTRINGINFO   structShowString[8];
} DEV_SHOWSTRING;

typedef struct tagDEV_SHOWSTRING2
{
    DWORD                dwSize;
    DEV_SHOWSTRINGINFO   structShowString[8];
} DEV_SHOWSTRING2;

typedef struct tagDEV_PREVIEW
{ 
    DWORD      dwSize;
    BYTE       byPreviewNumber;
    BYTE       byEnableAudio;
    BYTE       wSwitchTime;
    BYTE       bySwitchSeq[16];
} DEV_PREVIEW;

typedef struct tagDEV_PREVIEW2
{
    DWORD      dwSize;
    BYTE       byPreviewNumber;
    BYTE       byEnableAudio;
    BYTE       wSwitchTime;
    BYTE       bySwitchSeq[8][32];
    BYTE       byRes[24];
} DEV_PREVIEW2;

typedef struct tagDEV_VOOUT
{
    BYTE      byVideoFormat;
    BYTE      byMenuAlphaValue;
    WORD      wScreenSaveTime;
    WORD      wVOffset;
    WORD      wBrightness;
    BYTE      byStartMode;
    BYTE      byEnableScaler;
} DEV_VOOUT;

typedef struct tagDEV_VGAPARA
{
    WORD       wResolution;
    WORD       wFreq;
    DWORD      dwBrightness;
} DEV_VGAPARA;

typedef struct tagDEV_MATRIXPARA
{
    WORD       wDisplayLogo;
    WORD       wDisplayOsd;
} DEV_MATRIXPARA;

typedef struct tagDEV_VIDEOOUT
{
    DWORD                   dwSize;
    DEV_VOOUT               struVOOut[2];
    DEV_VGAPARA             struVGAPara[1];
    DEV_MATRIXPARA          struMatrixPara;
} DEV_VIDEOOUT;

typedef struct tagDEV_MATRIXPARA2
{
    WORD       wOrder[32];
    WORD       wSwitchTime;
    BYTE       res[14];
} DEV_MATRIXPARA2;

typedef struct tagDEV_VIDEOOUT2
{
    DWORD                       dwSize;
    DEV_VOOUT                   struVOOut[4];
    DEV_VGAPARA                 struVGAPara[4];
    DEV_MATRIXPARA2             struMatrixPara[16];
    BYTE                        byRes[16];
} DEV_VIDEOOUT2;

typedef struct tagDEV_USER_INFO
{
    BYTE      sUserName[32];
    BYTE      sPassword[16];
    DWORD     dwLocalRight[32];
    DWORD     dwRemoteRight[32];
    char      sUserIP[16];
    BYTE      byMACAddr[6];
} DEV_USER_INFO;

typedef struct tagDEV_USER
{
    DWORD                   dwSize;
    DEV_USER_INFO           struUser[16];
} DEV_USER;

typedef struct tagDEV_USER_INFO2
{
    BYTE                sUserName[32];
    BYTE                sPassword[16];
    BYTE                byLocalRight[32];
    BYTE                byRemoteRight[32];
    BYTE                byNetPreviewRight[64];
    BYTE                byLocalPlaybackRight[64];
    BYTE                byNetPlaybackRight[64];
    BYTE                byLocalRecordRight[64];
    BYTE                byNetRecordRight[64];
    BYTE                byLocalPTZRight[64];
    BYTE                byNetPTZRight[64];
    BYTE                byLocalBackupRight[64];
    DEV_IPADDR          struUserIP;
    BYTE                byMACAddr[6];
    BYTE                byPriority;
    BYTE                byRes[17];
} DEV_USER_INFO2;

typedef struct tagDEV_USER2
{
    DWORD                     dwSize;
    DEV_USER_INFO2            struUser[32];
} DEV_USER2;

typedef struct tagDEV_EXCEPTION
{
    DWORD                   dwSize;
    DEV_HANDLEEXCEPTION     struExceptionHandleType[16];
} DEV_EXCEPTION;

typedef struct tagDEV_EXCEPTION2
{
    DWORD                       dwSize;
    DEV_HANDLEEXCEPTION2        struExceptionHandleType[32]; 
} DEV_EXCEPTION2;

typedef struct tagDEV_TIMEPOINT
{
    DWORD    dwMonth;
    DWORD    dwWeekNo;
    DWORD    dwWeekDate;
    DWORD    dwHour;
    DWORD    dwMin;
} DEV_TIMEPOINT;

typedef struct tagDEV_ZONEANDDST
{
    DWORD                  dwSize;
    BYTE                   byRes1[16];
    DWORD                  dwEnableDST;
    BYTE                   byDSTBias;
    BYTE                   byRes2[3];
    DEV_TIMEPOINT          struBeginPoint;
    DEV_TIMEPOINT          struEndPoint;
} DEV_ZONEANDDST;
 
typedef struct tagDEV_AUXOUT
{
    DWORD     dwSize;
    DWORD     dwAlarmOutChan;
    DWORD     dwAlarmChanSwitchTime;
    DWORD     dwAuxSwitchTime[4];
    BYTE      byAuxOrder[4][16];  
} DEV_AUXOUT;

typedef struct tagDEV_NTPPARA
{
    BYTE           sNTPServer[64];
    WORD           wInterval;
    BYTE           byEnableNTP;
    signed char    cTimeDifferenceH;
    signed char    cTimeDifferenceM;
    BYTE           res1;
    WORD           wNtpPort;
    BYTE           res2[8]; 
} DEV_NTPPARA;

typedef struct tagDEV_DDNSPARA
{
    BYTE     sUserName[32];
    BYTE     sPassword[16];
    BYTE     sDomainName[64];
    BYTE     byEnableDDNS;
    BYTE     res[15];
} DEV_DDNSPARA;

typedef struct tagDEV_DDNS
{
    BYTE   sUserName[32];
    BYTE   sPassword[16];
    BYTE   sDomainName[64];
    BYTE   sServerName[64];
    WORD   wDDNSPort;
    BYTE   byRes[10];
} DEV_DDNS;

typedef struct tagDEV_DDNSPARA2
{
    BYTE        byEnableDDNS;
    BYTE        byHostIndex;
    BYTE        byRes1[2];
    DEV_DDNS    struDDNS[10];
    BYTE        byRes2[16];
} DEV_DDNSPARA2;

typedef struct tagDEV_NETAPP
{
    DWORD               dwSize;
    char                sDNSIp[16];
    DEV_NTPPARA         struNtpClientParam;
    DEV_DDNSPARA        struDDNSClientParam;
    BYTE                res[464];
} DEV_NETAPP;

typedef struct tagDEV_SINGLE_NFS
{
    char     sNfsHostIPAddr[16];
    BYTE     sNfsDirectory[128];
} DEV_SINGLE_NFS;

typedef struct tagDEV_NFS
{
    DWORD                   dwSize;
    DEV_SINGLE_NFS          struNfsDiskParam[8];
} DEV_NFS;

typedef struct tagDEV_IPDEVINFO
{
    DWORD              dwEnable;
    BYTE               sUserName[32];
    BYTE               sPassword[16];
    DEV_IPADDR         struIP;
    WORD               wDVRPort;
    BYTE               byRes[34];
} DEV_IPDEVINFO;

typedef struct tagDEV_IPCHANINFO
{
    BYTE     byEnable;
    BYTE     byIPID;
    BYTE     byChannel;
    BYTE     byRes[33];
} DEV_IPCHANINFO;

typedef struct tagDEV_IPPARA
{
    DWORD                  dwSize;
    DEV_IPDEVINFO          struIPDevInfo[32];
    BYTE                   byAnalogChanEnable[32];
    DEV_IPCHANINFO         struIPChanInfo[32];
} DEV_IPPARA;

typedef struct tagDEV_IPDEVINFO2
{
    BYTE               byEnable;
    BYTE               byProType;
    BYTE               byRes1[2];
    BYTE               sUserName[32];
    BYTE               sPassword[16];
    BYTE               byDomain[64];
    DEV_IPADDR         struIP;
    WORD               wDVRPort;
    BYTE               byRes2[34];
} DEV_IPDEVINFO2;

typedef struct tagDEV_IPPARA2
{
    DWORD                   dwSize;
    DEV_IPDEVINFO2          struIPDevInfo[32];
    BYTE                    byAnalogChanEnable[32];
    DEV_IPCHANINFO          struIPChanInfo[32];
} DEV_IPPARA2;

typedef struct tagDEV_IP_ALARM_ININFO
{
    BYTE     byIPID;
    BYTE     byAlarmIn;
    BYTE     byRes[18];
} DEV_IP_ALARM_ININFO;

typedef struct tagDEV_IP_ALARMIN
{
    DWORD                      dwSize;
    DEV_IP_ALARM_ININFO        struIPAlarmInInfo[128];   
} DEV_IP_ALARMIN;

typedef struct tagDEV_IP_ALARM_OUTINFO
{
    BYTE     byIPID;
    BYTE     byAlarmOut;
    BYTE     byRes[18];
} DEV_IP_ALARM_OUTINFO;

typedef struct tagDEV_IP_ALARMOUT
{
    DWORD                      dwSize;
    DEV_IP_ALARM_OUTINFO       struIPAlarmOutInfo[64];
} DEV_IP_ALARMOUT;

typedef struct tagDEV_COMPRESSCFG_AUD
{
	BYTE    byAudioEncType;
	BYTE    byres[7]; 
}DEV_COMPRESSION_AUDIO;

typedef struct tagDEV_RTSP
{
	DWORD    dwSize;
	WORD     wPort;
	BYTE     byReserve[54];
} DEV_RTSP;

typedef struct tagDEV_SERIALINDEX
{
	long    lSerialChan;
	int     iSelSerialIndex;
	char    sSendBuffer[1016];
} DEV_SERIALINDEX;

typedef struct tagDEV_SCALE
{
	DWORD    dwSize;
	DWORD    dwMajorScale;
	DWORD    dwMinorScale;
	DWORD    dwRes[2];
} DEV_SCALE;

typedef struct
{
	DWORD 	dwHDNo;
	DWORD 	dwCapacity;
	DWORD 	dwFreeSpace;
	DWORD 	dwHdStatus;
	BYTE	byHDAttr;
	BYTE	byHDType;
	BYTE	byRes1[2];
	DWORD 	dwHdGroup;
	BYTE	byRes2[120];
} DEV_SINGLE_HD, *LPDEV_SINGLE_HD;

typedef struct
{
	DWORD 			dwSize;
	DWORD 			dwHDCount;
	DEV_SINGLE_HD 	struHDInfo[33];
} DEV_HDCFG;

typedef struct tagDevCfgInfo
{           
    int				lChannel;
    DeviceCfgIndex  index;  
    void            *lpBuffer;
    DWORD        	dwBufferSize;
    DWORD	        dwBytesReturned;
    int				iWaittime;
    DWORD           dwUser;
} DEV_CFG_INFO, *LP_DEV_CFG_INFO;

typedef struct tagIpCfg
{
	char ip[16];
	char mask[16];
	char gateway[16];
	char mac[24];
} IpCfg;

typedef struct tagDnsCfg
{
	char dns1[16];
	char dns2[16];
} DnsCfg;

typedef struct tagNetLocalCfg
{
	int bdhcp;					//dhcp or static
	int bautodns;				//get dns automaticaly or static configure
	IpCfg ipconfig;				//ip configure
	DnsCfg dnsconfig;			//dns configure
} NetLocalCfg;

typedef struct
{
    char name[128];
    char pass[128];
}NetPPPoECfg,*PNetPPPoEcFG;

typedef enum
{
    NET_LAN,
    NET_PPPOE,
    NET_CDMA
}NetLinkType;

typedef struct
{
    int enable;
}NetUPNPCfg, *PNetUPNPCfg;

typedef struct
{
    int reso;
    char name[32];
}NetResoType;

typedef struct
{
    int types;
    int cur;
    NetResoType list[32];
}NetResotList;

typedef struct
{
    int max;
    int min;
    int cur;
}NetUITrans;

typedef struct
{
    int max;
    int min;
    int cur;
}NetMouseSense;

typedef struct
{
    int types;
    int cur;
    int list[16];
}NetDellTable;

typedef struct
{
    NetResotList reso;
    NetUITrans trans;
    NetMouseSense mouseSense;
    NetDellTable dwell;
    int bmute;
}NetOutputCfg,*PNetOutputCfg;

typedef struct
{
    int display;
    int recording;
    int network;
    int alarm;
    int device;
    int system;
}NetRestoreCfg,*PNetRestoreCfg;

typedef struct
{
    int enable;
    int week_day;
    int hour;
    int min;
    int second;
}NetAutoRebootCfg,*PNetAutoRebootCfg;

typedef struct
{
    int number;
    int capacity;
    int b_format;
    int b_mount;
    int remain_size;
}NetHddInfo;

typedef struct
{
    int total;
    NetHddInfo hddInfo[10];
}NetHddCfg,*PNetHddCfg;

typedef struct
{
    int total;
    int init_id[10];
}NetHddInitInfo,*PNetHddInitInfo;


typedef struct
{
   int video_standard;
   int time_zone;
   int date_format;
   int year;
   int month;
   int day;
   int hour;
   int min;
   int second;
   int device_id;
}NetSysGeneralCfg,*PNetSysGeneralCfg;

typedef struct
{
    int enable;
    int offset;
    int mode;

    int start_month;
    int start_index;
    int start_weekday;
    int start_hour;
    int start_minute;
    int start_second;

    int end_month;
    int end_index;
    int end_weekday;
    int end_hour;
    int end_minute;
    int end_second;
}NetDstCfg, *PNetDstCfg;


typedef struct
{
	int bautoapn;
	char apn[128];
	char phone[32];/*dial phone num*/
	char name[128];/*user name */
	char pass[32];/*user password*/
	int bautoip;
	int bautodns;
	IpCfg ip;
	DnsCfg dns;
}Net3GConfig, *PNet3GConfig;

typedef struct
{
	int port;
}NetServiceConfig, *PNetServiceConfig;

typedef struct
{
	int port;
}NetWebConfig, *PNetWebConfig;

typedef struct
{
	char server[32];
	int port;
	int bnonymous;
	char username[32];
	char password[32];
	char remotedir[256];
	int filelen;	
}NET_DVR_FTP_CFG, *PNET_DVR_FTP_CFG;

typedef struct {
	char    byStartHour;
	char    byStartMin;
	char    byStopHour;
	char    byStopMin;
}NET_DVR_MTIME, *PNET_DVR_MTIME;

typedef struct
{
	NET_DVR_MTIME time;
	int type;
}NET_DVR_SCHEDULE, *PNET_DVR_SCHEDULE; 

typedef struct
{
	int channel;
	int bvalid;
	NET_DVR_SCHEDULE timetable[7][2];
}NET_DVR_FTP_TASK, *PNET_DVR_FTP_TASK;

typedef struct
{
	int type;    // 0:ipfilter invalid   1:white valid  2:black valid
	char white[64][16];
	char black[64][16];
}NET_DVR_IP_FILTER, *PNET_DVR_IPFILTER;


class IDevConfig
{
public: 
    virtual BOOL GetDeviceConfig(LP_DEV_CFG_INFO lpDevCfg) = 0;
    virtual BOOL SetDeviceConfig(LP_DEV_CFG_INFO lpDevCfg) = 0;
	virtual BOOL GetChannelEncInfo(int nChannel, int nStreamType, int nResolution, LPCOMPRESSION_INFO lpStreamInfo) = 0;
    virtual int  Upgrade(char *sFileName, int iUpgradeConfig) = 0;
	virtual int  Export(char *sFileName) = 0;
	virtual int  Import(char *sFileName) = 0;
    virtual BOOL GetLog(char *sFileName) = 0;
	virtual int  GetLogFilePercent() = 0;
    virtual int  GetExportFilePercent() = 0;
	int m_errno;
};

class DLLAPI CDevConfigFactory
{
public:
	static IDevConfig *CreateDevConfig(IDevUserLogin *pUser);
	static void DeleteDevConfig(IDevConfig *Config, IDevUserLogin *pUsr);
};
#endif
